uses playzsm1, sblaster, crt;
  var track: byte;
      titel: string[20];
      composer: string[20];
      i: byte;
      fname: string[20];
      key: bytebool;
      ch: char;
      ln10: real;
      lastpatpos: word;
   const bsize = 512;


procedure display_vu;
  var i: shortint;
  db: shortint;
begin

  if vumeter = 0 then db := -128 else
    db := trunc(20 * ln(vumeter / 256) / ln10);



  gotoxy(76, 19);
  if vumeter > 256 then
    write('CLIP')
  else
    write('    ');




  gotoxy(37, 17);

  {
  if db < 0 then
  begin
  }


  if db > 6 then db := 6;

  if db < -33 then for i := -33 to 6 do write('')
  else
  begin

    for i := -33 to db do
      write('');

    for i := db+1 to 6 do
      write('');

  end;


end;




begin
  lastpatpos := 65535;
  vumeter := 0;
  ln10 := ln(10);

  if paramstr(1) = '' then
  begin
    write('ZSM-Datei (ohne Erw.): ');
    readln(fname);
  end
  else
    fname := paramstr(1);
  fname := fname + '.zsm';


  if load_zsm(fname) <> 0 then
  begin
    writeln('Error opening ', fname);
    halt(1);
  end;


  calc_pattern_sizes;


  for i := 0 to 19 do
    titel[i+1] := zsmheader.titel[i];
  i := 20;
  while (i > 0) and (titel[i] = chr(0)) do dec(i);
  titel[0] := chr(i);

  for i := 0 to 19 do
    composer[i+1] := zsmheader.composer[i];
  i := 20;
  while (i > 0) and (composer[i] = chr(0)) do dec(i);
  composer[0] := chr(i);


  clrscr;

  gotoxy(16, 1); write('-=ZSMPLAY=- v0.02 by Zatzen 2016');

  gotoxy(13, 3); write('Song Name: ', titel);
  if titel[0] = chr(0) then write ('(none)');
  write('     Composer: ', composer);
  if composer[0] = chr(0) then write('(unknown)');


  gotoxy(36, 15);write('-33   -27   -21   -15   -9    -3  0    +6');
  gotoxy(37, 16); write('                                ');
  gotoxy(37, 17); write(' dB');
  gotoxy(37, 18); write('                              ');
  gotoxy(37, 19); write('  -30   -24   -18   -12   -6     0 +3 ');

  gotoxy(57, 6); write('Channels:');
  gotoxy(48, 8); write('01  02  03  04  05  06  07  08');
  gotoxy(48, 11); write('09  10  11  12  13  14  15  16');

  gotoxy(24, 5); write('Sequencer: ');
  gotoxy(26, 6); write('Pattern: ');
  gotoxy(22, 7); write('Pattern Row: ');

  gotoxy(13, 10); write('Pattern Size (Bytes):');
  gotoxy(2, 11); write('Pattern Header & Tables (Bytes):');
  gotoxy(3, 12); write('Position in Patterndata (Byte):');
  gotoxy(3, 13); write('Avg. Bits/Row:       Bytes/Sec: ');
  gotoxy(12, 8); write('Offset In Patterndata: ');

  gotoxy(1, 16);
  writeln('File: ', fname);
  writeln('Size: ', zsmfilesize, ' Bytes');
  writeln('Patterndata Size Total: ', zsmheader.patterndata_size, ' Bytes');

  writeln('Biggest Pattern: ', biggest_pattern, ' Bytes');

  writeln('Smallest Pattern: ', smallest_pattern, ' Bytes');

  writeln('Average Pattern Size: ', zsmheader.patterndata_size div number_of_patterns, ' Bytes');

  writeln('Samples: ', zsmheader.sample_entries);

  writeln('Pitch Tables Size: ', ptablesize, ' Bytes');

  writeln('Sample Data: ', smpblocksize, ' Bytes');

  write('Sequencer Loop: ', zsmheader.sequencer_loopstart, ' - ', zsmheader.sequencer_loopend);

  gotoxy(37, 21); write('(V)olume Attenuation: -6 dB');
  gotoxy(37, 23); write('+ - to increase/decrease Sequencer Position');
  gotoxy(37, 24); write('Esc to exit');




  goto_sequ(1);


  init_zsm_soundbuffer(bsize);

  if init_sound(bsize) > 0 then
  begin
    writeln('Error initializing Soundblaster');
    halt(1);
  end;


  repeat

    for track := 0 to 7 do
    begin
      gotoxy (48+track * 4, 9);
      if chan_event[track] then write('') else
        if play_sample[track] then write('') else
          if trk_active[track] then write('') else write('--');
    end;

    for track := 8 to 15 do
    begin
      gotoxy (48+(track-8) * 4, 12);
      if chan_event[track] then write('') else
        if play_sample[track] then write('') else
          if trk_active[track] then write('') else write('--');
    end;


    gotoxy(35, 5); write(actual_sequ:4, ' /', zsmheader.sequencer_entries:4);
    gotoxy(35, 6); write(act_pattern_number:4, ' /', number_of_patterns:4);
    gotoxy(36, 7); write(patternrow_act:3, ' /', patternrowstotal:4);

    gotoxy(35, 10); write(act_pattern_size:4);
    gotoxy(34, 11); write(pattheaderandtables:5);
    gotoxy(34, 12); write(patternpos:5);

    display_vu;

    if patternpos <> lastpatpos then
    begin
      lastpatpos := patternpos;
      gotoxy(17, 13);
        write(round(patternpos*8 / (patternrow_act+1)):3);
      gotoxy(36, 13);
        write(patternpos / (patternrow_act+1) * 22050 / actual_spl_per_row:3:1, ' ');
      gotoxy(34, 8); write(offset_in_patterndata:5);
    end;


    fill_soundbuffer;
    sound_nextframe := false;



    repeat until sound_nextframe;

    asm
      mov ax, 0b00h;
      int 21h;
      mov key, al;
    end;
    if key then
    begin
      ch := readkey;
      if ch = '+' then begin inc_sequ; ch := chr(0); end;
      if ch = '-' then begin dec_sequ; ch := chr(0); end;
      if upcase(ch) = 'V' then
      begin
        inc(mixvol);
        if mixvol > 2 then mixvol := 0;
        gotoxy(59, 21);
        if mixvol > 0 then write('-',mixvol*6, ' dB ')
        else write ('0 dB  ');
      end;
    end;

  until ch = chr(27);

  writeln(key, '<<');
  deinit_sound;

  clear_zsm;

  clrscr;
end.