{$G+}

(********************************************************************)
(* Beni Tracker v1.8 Player - Pascal Version, v0.8a, by Zatzen 2020 *)
(************************* NOT YET A UNIT ***************************)

uses crt; { vorbergehend }

var
  length, nptns, ninstrs, biggestptn, biggestins: byte;

type instrument = record
  mul1, mul2, lev1, lev2, atd1, atd2, sur1, sur2, wav1, wav2, fbcon: byte;
end;

type byte_struc = array[0..65534] of byte;
type ordr_struc = array[0..255, 0..8] of byte;
type ins_struc = array[0..32] of instrument;

var
  alloc_heap: array[1..8] of word;
  n, o, i, eh, el: byte;
  edrow: integer;
  edrowjump: boolean;

  ptnmap_poi: pointer;
  insmap_poi: pointer;
  ordr_poi: pointer;
  ins_poi: pointer;

  pdat_ofstab_ofs, pdat_ofstab_seg: word;
  pdata_ofs, pdata_seg: word;
  rowidx_ofs, rowidx_seg: word;
  cmppat_row_ofs, cmppat_row_seg: word;

  pdat_ofstab_poi: pointer absolute pdat_ofstab_ofs;
  pdata_poi: pointer absolute pdata_ofs;
  rowidx_poi: pointer absolute rowidx_ofs;
  cmppat_row_poi: pointer absolute cmppat_row_ofs;


  ptnmap: ^byte_struc absolute ptnmap_poi;
  insmap: ^byte_struc absolute insmap_poi;
  ordr: ^ordr_struc absolute ordr_poi;
  ins: ^ins_struc absolute ins_poi;


  count, speed: byte;
  edpos: byte;
  e6xrow, e6xcount, e6x: integer;

  vocini: array[0..8] of integer;
  vocnte, vocvol, vococt: array[0..8] of byte;

  vocfrq: array[0..8] of word;

  prtsrcfrq, prtsrco: array[0..8] of integer;
  prtdstfrq, prtdsto: array[0..8] of integer;

  arpi: byte;
  flgarp: array[0..8] of byte;
  frqadd, prtadd, prtsign: array[0..8] of integer;

  lastel, lasteh: array[0..8] of integer;

  arpfrq: array[0..2, 0..8] of word;
  arpoct: array[0..2, 0..8] of byte;

  posjmp, ptnbrk: integer;

const
  frqtab: array[0..11] of word =
  ($157, $16B, $181, $198, $1B0, $1CA, $1E5, $202, $220, $241, $263, $287);
  vocoff: array[0..8] of byte = (0, 1, 2, 8, 9, 10, 16, 17, 18);

procedure skip_ptn_rows(ptn, rows: word); assembler;
{ Zeilenoffsets weiterzhlen zum skippen von beim spielen bersprungenen edrows etc. }
asm

  xor dl, dl
  mov cx, rows
  or cx, cx
  jz @setcount

  mov es, rowidx_seg
  mov si, rowidx_ofs
  mov ax, ptn
  shl ax, 3 { ptn * 8 }
  add si, ax  { si offset zu pattern bit idx }

  mov ch, cl
  and ch, 32
  jz @skip

  db 66h; mov ax, es:[si]
  add si, 4
  @loop1:
    db 66h; add ax, ax
    adc dl, 0
    dec ch
    jnz @loop1

  @skip:
    and cl, 31
    jz @setcount
    mov ch, cl
    neg cl
    add cl, 32  { cl = 32 - cl }
    db 66h; mov ax, es:[si]
    db 66h; shl ax, cl
    @loop2:
      db 66h; add ax, ax
      adc dl, 0
      dec ch
      jnz @loop2

  @setcount:
  mov es, cmppat_row_seg { Datenfeld der Zeilenzhler der kompr. Patterns }
  mov si, cmppat_row_ofs
  mov bx, ptn
  mov es:[si+bx], dl { Zeilenzhler an Position im Zhlerarray erhhen }

end;


procedure read_ptn_row(ptn: word); assembler;
asm
  mov di, ptn

  mov n, 12
  db 66h; xor ax, ax
  db 66h; mov ds:[offset o], ax { o, i eh, el nullen }

  mov es, rowidx_seg
  mov si, rowidx_ofs

  { berprfen ob Zeile nummer edrow genutzt/belegt ist }
  mov cx, edrow
  mov ax, ptn
  shl ax, 3 { ptn * 8 }
  add si, ax  { si offset zu pattern bit idx }

  test cx, 32 { zweite Patternhlfte ? }
  jz @skip
    and cx, 31
    add si, 4
  @skip:
  db 66h; mov ax, es:[si]
  db 66h; shr ax, cl
  test al, 1 { Zeile genutzt ? }
  jz @end { nein? -> beenden }
  mov es, cmppat_row_seg { Datenfeld der Zeilenzhler der kompr. Patterns }
  mov si, cmppat_row_ofs
  mov bx, ptn
  xor ax, ax
  mov al, es:[si+bx]     { al enthlt nun momentane Zeilennummer }
  inc byte ptr es:[si+bx] { Zeilenzhler an Position im Zhlerarray erhhen }
  mov bx, ax
  add bx, ax
  add bx, ax  { in BX steht nun Zeilenoffset * 3 }

  mov es, pdat_ofstab_seg { Patternoffset-Tabelle (komprimierte Patterns) }
  mov si, pdat_ofstab_ofs
  add si, di
  add si, di              { 2x Pattern-Nr. -> Offset in die Tabelle }
  add bx, es:[si]
  { in BX steht nun Patterndaten-Offset + Zeilenoffset * 3 }

  mov es, pdata_seg
  mov si, pdata_ofs

  mov dx, es:[si+bx]
  mov ax, dx
  shr al, 4
  mov n, al
  mov ax, dx
  shr al, 1
  and al, 7
  mov o, al
  mov ax, dx
  xchg al, ah
  shr ax, 4
  and al, 31
  mov i, al
  and dh, 15
  mov eh, dh
  mov al, es:[si+bx+2]
  mov el, al

  @end:
end;

procedure fill_rowidx(src: pointer; ptn: word); assembler;
asm
  db 66h; xor di, di
  mov dx, ptn
  mov es, rowidx_seg
  mov di, rowidx_ofs
  push ds
  lds si, src


  { nachdem DS fr eigene Zwecke gesetzt wird kann nicht mehr }
  { auf Variablen zugegriffen werden, deshalb muss DS als letztes }
  { umdefiniert werden, folgend nur Registeroperationen: }

  shl dx, 3
  add di, dx { di enthlt Offset zu rowinfo, ptn * 8 }


  db 66h; xor ax, ax { EAX nullen, dort kommt die Row-Info hinein }
                     { und dann in den Speicher }
  xor cx, cx
  @loop1:

     mov dl, ds:[si]
     cmp dl, 0c0h
     jne @copy1
     test dl, 15
     jnz @copy1
     mov dx, ds:[si+1]
     or dx, dx
     jz @skip1
        @copy1:
        inc ax
      @skip1:
      db 66h; ror ax, 1
      add si, 3
      inc cx            { row erhhen }
      test cx, 32       { prfen ob die Hlfte des Patterns durch ist }
      jz @loop1         { wenn nicht dann erneut die Schleife durchlaufen }
  db 66h; mov es:[di], ax  { EAX in den Row-Info Speicher schreiben }

  { hier nun das gleiche noch einmal fr die rows 32-63 }
  { si zeigt hier zu Beginn auf row 32, und di wird um + 4 ergnzt }
  db 66h; xor ax, ax
  xor cx, cx
  @loop2:
     mov dl, ds:[si]
     cmp dl, 0c0h
     jne @copy2
     test dl, 15
     jnz @copy2
     mov dx, ds:[si+1]
     or dx, dx
     jz @skip2
        @copy2:
        inc ax
      @skip2:
      db 66h; ror ax, 1
      add si, 3
      inc cx; test cx, 32
      jz @loop2
  db 66h; mov es:[di+4], ax

  pop ds
end;

function calc_sum_used_rows(patterns: word): word; assembler;
asm
  mov es, rowidx_seg
  mov si, rowidx_ofs
  mov bx, patterns
  shl bx, 3
  add bx, si
  xor ax, ax
  @loop:
    db 66h; mov dx, es:[si]
    mov cx, 32
    @bitloop:
      db 66h; add dx, dx
      adc ax, 0
      dec cx
      jnz @bitloop
    add si, 4
    cmp si, bx
    jne @loop
end;

procedure write_pdat_ofstab(patn, val: word); assembler;
asm
  les si, pdat_ofstab_poi
  mov bx, patn
  add bx, bx
  mov ax, val
  mov es:[si+bx], ax
end;

function copy_only_used_rows(src: pointer; _offset: word): word; assembler;
asm
  mov es, pdata_seg
  mov di, pdata_ofs

  les di, pdata_poi
  mov bx, _offset
  push ds
  lds si, src
  mov cx, 64
  @loop:
     mov dl, ds:[si]
     cmp dl, 0c0h
     jne @copy
     test dl, 15
     jnz @copy
     mov dx, ds:[si+1]
     or dx, dx
     jz @skip
       @copy:
       mov dl, ds:[si]
       mov es:[di+bx], dl
       mov dx, ds:[si+1]
       mov es:[di+bx+1], dx
       add bx, 3
    @skip:
       add si, 3
    dec cx
    jnz @loop
  pop ds
  mov ax, bx
end;


procedure opl_out(reg, vlu: byte); assembler;
asm
  mov al, reg
  mov dx, 0388h
  out dx, al
  in al, dx
  mov al, vlu
  inc dx
  out dx, al
  dec dx
  in al, dx
  in al, dx
  in al, dx
end;


procedure opl_setinstr(v: byte; i: instrument);
  var reg: byte;
begin
  reg := $20 + VocOff[v];
  opl_out(reg, i.mul1); inc(reg, 3);
  opl_out(reg, i.mul2); inc(reg, $1D);
  opl_out(reg, i.lev1); inc(reg, 3);
  opl_out(reg, i.lev2); inc(reg, $1D);
  opl_out(reg, i.atd1); inc(reg, 3);
  opl_out(reg, i.atd2); inc(reg, $1D);
  opl_out(reg, i.sur1); inc(reg, 3);
  opl_out(reg, i.sur2); inc(reg, $5D);
  opl_out(reg, i.wav1); inc(reg, 3);
  opl_out(reg, i.wav2); inc(reg, $1D);
  opl_out($C0 + v, i.fbcon);
end;


procedure bt_play_int; { interrupt }
  var
    v, l1, l2, oct, an1, an2: byte;
    lol: integer;
    frq: word;
    ti: integer;
begin

  inc(count);

  if count = speed then
  begin

    for v := 0 to 8 do
      if edrowjump then
        skip_ptn_rows(ordr^[edpos, v], edrow);
    edrowjump := false;

    for v := 0 to 8 do begin

      read_ptn_row(ordr^[edpos, v]);

      if eh = 3 then
      begin

        if boolean(i) then
        begin
          if vocini[v] <> i then
          begin
            opl_setinstr(v, ins^[i]);
            vocini[v] := i;
          end;
          if vocvol[v] < 63 then
          begin
            l1 := 64 - (64 * word(64 - ins^[i].lev1)) shr 6;
            l2 := 64 - (64 * word(64 - ins^[i].lev2)) shr 6;
            opl_out($40 + vocoff[v], l1);
            opl_out($43 + vocoff[v], l2);
          end;
          vocvol[v] := 63;
        end; { if boolean(i) then } { OK }

        if n < 12 then
        begin
          frq := vocfrq[v];
          oct := vococt[v];
          prtsrcfrq[v] := frq;
          prtsrco[v] := oct;
          prtdstfrq[v] := frqtab[n];
          prtdsto[v] := o;
          if prtdsto[v] < oct then
            prtsign[v] := -1
          else if prtdsto[v] > oct then
            prtsign[v] := 1
          else
          begin
            if prtdstfrq[v] < frq then
              prtsign[v] := -1
            else
              prtsign[v] := 1;
          end;
        end; { if n < 12 then } { OK }

      end { if eh = 3 then } { OK }
      else if boolean(i) then
      begin

        if n < 12 then
        { n + i }
        begin
          lastel[v] := -1;
          opl_out($B0 + v, 0);
          if eh <> $C then
          begin

            if vocini[v] <> i then
            begin
              opl_setinstr(v, ins^[i]);
              vocini[v] := i;
            end
            else
            begin
              if vocvol[v] < 63 then
              begin
                { hobby illuminati bug fixed }
                l1 := 64 - (64 * word(64 - ins^[i].lev1)) shr 6;
                l2 := 64 - (64 * word(64 - ins^[i].lev2)) shr 6;
                opl_out($40 + vocoff[v], l1);
                opl_out($43 + vocoff[v], l2);
              end;
            end; { else }
            vocvol[v] := 63;
          end { if eh <> $C } { OK }
          else
          begin

            if vocini[v] <> i then
            begin
              opl_setinstr(v, ins^[i]);
              vocini[v] := i;
            end;
            l1 := 62 - (word(el) * word(64 - ins^[i].lev1)) shr 6;
            l2 := 62 - (word(el) * word(64 - ins^[i].lev2)) shr 6;
            opl_out($40 + vocoff[v], l1);
            opl_out($43 + vocoff[v], l2);
            vocvol[v] := el;

          end; { OK }
          frq := frqtab[n];
          opl_out($A0 + v, frq);
          opl_out($B0 + v, 32 or (o shl 2) or (frq shr 8));
          vocnte[v] := n;
          vococt[v] := o;
          vocfrq[v] := frq;

        end { if n < 12 then }
        else { hier nun fr n = 12 }
        { i }
        begin

          if vocini[v] <> i then
          begin

            opl_setinstr(v, ins^[i]);
            vocini[v] := i;
            if eh = $C then
            begin

              l1 := 62 - (word(el) * word(64 - ins^[i].lev1)) shr 6;
              l2 := 62 - (word(el) * word(64 - ins^[i].lev2)) shr 6;
              opl_out($40 + vocoff[v], l1);
              opl_out($43 + vocoff[v], l2);

            end
            else
            begin

              if vocvol[v] < 63 then
              begin
                l1 := 64 - (word(vocvol[v]) * word(64 - ins^[i].lev1)) shr 6;
                l2 := 64 - (word(vocvol[v]) * word(64 - ins^[i].lev2)) shr 6;
                opl_out($40 + vocoff[v], l1);
                opl_out($43 + vocoff[v], l2);
              end;

            end; { else if eh ... }
          end; { if vocini[v] <> i then } { OK }

          if boolean(lastel[v]) then
          begin

            if lasteh[v] = 0 then
            begin
              frq := vocfrq[v];
              opl_out($A0 + v, frq);
              opl_out($B0 + v, 32 or (vococt[v] shl 2) or (frq shr 8));
            end;

          end; { boolean(lastel[v]) }

        end; { else von if n < 12 then }

      end { else if boolean(i) } { OK }
      else { if boolean (not) i }
      { n }
      begin
        if n < 12 then
        begin

          lastel[v] := -1;
          if eh = $C then
          begin
            ti := vocini[v];
            if ti >= 0 then
            begin
              l1 := 62 - (word(el) * word(64 - ins^[ti].lev1)) shr 6;
              l2 := 62 - (word(el) * word(64 - ins^[ti].lev2)) shr 6;
              opl_out($40 + vocoff[v], l1);
              opl_out($43 + vocoff[v], l2);
              vocvol[v] := el
            end; { if ti ... }
          end { if eh ... }
          else
          begin

            if vocvol[v] < 63 then
            begin
              ti := vocini[v];
              if ti >= 0 then
              begin
                l1 := 64 - (word(vocvol[v]) * word(64 - ins^[ti].lev1)) shr 6;
                l2 := 64 - (word(vocvol[v]) * word(64 - ins^[ti].lev2)) shr 6;
                opl_out($40 + vocoff[v], l1);
                opl_out($43 + vocoff[v], l2);
              end;
            end; { else if vocvol[v] < 63 then } { OK }

          end; { else von if eh = $C } { OK }
          frq := frqtab[n];
          opl_out ($A0 + v, frq);
          opl_out ($B0 + v, 32 or (o shl 2) or (frq shr 8));

          vocnte[v] := n;
          vococt[v] := o;
          vocfrq[v] := frq;

        end { if n < 12 }
        else
        {e?}
        begin
          if eh = $C then
          begin
            ti := vocini[v];
            if ti >= 0 then
            begin
              l1 := 62 - (word(el) * word(64 - ins^[ti].lev1)) shr 6;
              l2 := 62 - (word(el) * word(64 - ins^[ti].lev2)) shr 6;
              opl_out($40 + vocoff[v], l1);
              opl_out($43 + vocoff[v], l2);
              vocvol[v] := el;
            end;
          end; {if eh = $C then }
          if boolean(lastel[v]) then
          begin
            if lasteh[v] = 0 then
            begin
              frq := vocfrq[v];
              opl_out($A0 + v, frq);
              opl_out($B0 + v, 32 or (vococt[v] shl 2) or (frq shr 8));
            end;
          end;

        end;
      end;

      { erste IF-Kaskade abgeschlossen }

      case eh of

        0:
        begin
          if boolean(el) then
          begin
            if el <> lastel[v] then
            begin
              n := vocnte[v];
              o := vococt[v];
              arpfrq[0, v] := frqtab[n];
              arpoct[0, v] := o;
              an1 := n + el shr 4;
              an2 := n + el and 15;
              if an1 < 12 then
              begin
                arpfrq[1, v] := frqtab[an1];
                arpoct[1, v] := o;
              end
              else
              begin
                arpfrq[1, v] := frqtab[an1 - 12];
                arpoct[1, v] := o + 1;
              end;
              if an2 < 12 then
              begin
                arpfrq[2, v] := frqtab[an2];
                arpoct[2, v] := o;
              end
              else
              begin
                arpfrq[2, v] := frqtab[an2 - 12];
                arpoct[2, v] := o + 1;
              end;
            end; { if el <> lastel }
            flgarp[v] := 1;
          end { if boolean(el) }
          else
            flgarp[v] := 0;
          frqadd[v] := 0;
          prtadd[v] := 0;
        end; { case 0}

        $1:
        begin
          prtadd[v] := 0;
          flgarp[v] := 0;
          frqadd[v] := el;
        end;

        $2:
        begin
          prtadd[v] := 0;
          flgarp[v] := 0;
          frqadd[v] := - el;
        end;

        $3:
        begin
          frqadd[v] := 0;
          flgarp[v] := 0;
          prtadd[v] := el;
        end;

        $B:
        begin
          frqadd[v] := 0;
          prtadd[v] := 0;
          flgarp[v] := 0;
          posjmp := el;
        end;

        $D:
        begin
          frqadd[v] := 0;
          prtadd[v] := 0;
          flgarp[v] := 0;
          ptnbrk := el;
        end;

        $F:
        begin
          frqadd[v] := 0;
          prtadd[v] := 0;
          flgarp[v] := 0;
          speed := el;
        end;

        $E:
          begin
          case (el shr 4) of

            6:
            begin
              if e6x = 0 then
                if (el and 15) = 0 then
                  e6xrow := edrow
                else
                begin
                  e6xcount := el and 15;
                  e6x := 1
                end;
              if e6x = 1 then
                if (el and 15) > 0 then
                begin
                  dec(e6xcount);
                  if e6xcount >= 0 then
                  begin
                    edrow := e6xrow - 1;
                    edrowjump := true;
                  end
                  else
                    e6x := 0;
                end;
            end;

            $A:
            begin
              ti := vocini[v];
              if ti >= 0 then
              begin
                lol := vocvol[v] + el and 15;
                if lol > 63 then lol := 63;
                l1 := 64 - (word(lol) * word(64 - ins^[ti].lev1)) shr 6;
                l2 := 64 - (word(lol) * word(64 - ins^[ti].lev2)) shr 6;
                opl_out($40 + vocoff[v], l1);
                opl_out($43 + vocoff[v], l2);
                vocvol[v] := lol;
              end;
            end;

            $B:
            begin
              ti := vocini[v];
              if ti >= 0 then
              begin
                lol := vocvol[v] - el and 15;
                if lol < 2 then lol := 2;
                l1 := 64 - (word(lol) * word(64 - ins^[ti].lev1)) shr 6;
                l2 := 64 - (word(lol) * word(64 - ins^[ti].lev2)) shr 6;
                opl_out($40 + vocoff[v], l1);
                opl_out($43 + vocoff[v], l2);
                vocvol[v] := lol;
              end;
            end;

          end; { case el shr 4 of }
          frqadd[v] := 0;
          prtadd[v] := 0;
          flgarp[v] := 0;
          end;
      end; { case eh of }

      lasteh[v] := eh;
      lastel[v] := el;

    end; { for v }

    if posjmp >= 0 then
    begin
      edpos := posjmp;
      if ptnbrk = -1 then
      begin
        edrow := 0;
        edrowjump := true;
      end
      else
      begin
        edrow := ptnbrk;
        edrowjump := true;
        ptnbrk := -1;
      end;
      posjmp := -1;
    end
    else
    if ptnbrk >= 0 then
    begin
      inc(edpos);
      if edpos = length then edpos := 0;
      edrow := ptnbrk;
      edrowjump := true;
      ptnbrk := -1;
    end
    else
    begin
      inc(edrow);
      if edrow = 64 then
      begin
        inc(edpos);
        if edpos = length then edpos := 0;
        edrow := 0;
        edrowjump := true;
      end;
    end;

  count := 0;

  end { if count = speed }
  else
  begin

    { ARPI }

    inc(arpi);
    if arpi = 3 then arpi := 0;
    for v := 0 to 8 do
    begin

      if boolean(frqadd[v]) then
      begin

        inc(vocfrq[v], frqadd[v]);
        frq := vocfrq[v];
        opl_out($A0 + v, frq);
        opl_out($B0 + v, 32 or (vococt[v] shl 2) or (frq shr 8));

      end
      else
      if boolean(prtadd[v]) then
      begin

        frq := vocfrq[v];
        oct := vococt[v];

        if prtsign[v] = 1 then
        begin
          inc(frq, prtadd[v]);
          if oct = prtdsto[v] then
            if frq > prtdstfrq[v] then
            begin
              frq := prtdstfrq[v];
              prtadd[v] := 0;
            end;

          if frq > $287 then
          begin
            frq := $143 + (frq - $287);
            inc(oct);
          end;

        end { if prtsign[v] = 1 then }
        else
        begin

          dec(frq, prtadd[v]);
          if oct = prtdsto[v] then
            if frq < prtdstfrq[v] then
            begin
              frq := prtdstfrq[v];
              prtadd[v] := 0;
            end;

          if frq < $157 then
          begin
            frq := $2AE - ($157 - frq);
            dec(oct);
          end;

        end; { if prtsign ... else }

        opl_out($A0 + v, frq);
        opl_out($B0 + v, 32 or (oct shl 2) or (frq shr 8));
        vocfrq[v] := frq;
        vococt[v] := oct;

      end { if boolean(prtadd[v]) then }
      else
      if boolean(flgarp[v]) then
      begin
        frq := arpfrq[arpi, v];
        opl_out($A0 + v, frq);
        opl_out($B0 + v, 32 or (arpoct[arpi, v] shl 2) or (frq shr 8));
      end;

    end; { for v := 0 to 8 do }

  end; { if count = speed ... else }

end;


procedure loadmod(filenm: string);
{ darf in dieser Form wegen den GetMem's nur einmal aufgerufen werden }
{ es sei denn man gibt den hier alloziierten Speicher wieder frei (freemem) }
  var
    f: file;
    a: word;
    file_patpos: longint;
    sum_used_rows: word;
    patofs, pofs: word;
    pat_tmp_poi: pointer;
    usedheapmem: longint;
begin
  usedheapmem := 0;
  assign(f, filenm); reset(f, 1);

  { "Header" }
  blockread(f, length, 3);
  writeln('order length: ',length, '  patterns: ', nptns, '  instruments: ', ninstrs);

  { Pattern / Instrument - Mapper }
  getmem(ptnmap_poi, nptns);
  getmem(insmap_poi, ninstrs);
  alloc_heap[1] := nptns;
  alloc_heap[2] := ninstrs;
  blockread(f, ptnmap_poi^, nptns);
  blockread(f, insmap_poi^, ninstrs);

  getmem(ordr_poi, word(length) * 9); { Sequencer auf Heap einrichten + laden }
  alloc_heap[3] := word(length) * 9;
  blockread(f, ordr_poi^, word(length) * 9);

  { Grte Pattern-Nummer aus dem Mapper beziehen }
  { und anhand dessen Speicher reservieren }

  biggestptn := 0; for a := 0 to nptns - 1 do
    if ptnmap^[a] > biggestptn then biggestptn := ptnmap^[a];

  getmem(rowidx_poi, (biggestptn + 1) shl 3);
  alloc_heap[4] := (biggestptn + 1) shl 3;
  fillchar(rowidx_poi^, (biggestptn + 1) shl 3, 0);
  getmem(pdat_ofstab_poi, (biggestptn + 1) shl 1);
  alloc_heap[5] := (biggestptn + 1) shl 1;
  fillchar(pdat_ofstab_poi^, (biggestptn + 1) shl 1, 0);
  getmem(cmppat_row_poi, biggestptn + 1);
  alloc_heap[6] := biggestptn + 1;
  fillchar(cmppat_row_poi^, biggestptn + 1, 0);

  file_patpos := filepos(f);
  getmem(pat_tmp_poi, 192);
  for a := 0 to nptns - 1 do
  begin
    blockread(f, pat_tmp_poi^, 192);
{    write(ptnmap^[a], ' ');}
    fill_rowidx(pat_tmp_poi, ptnmap^[a]);
  end;
  freemem(pat_tmp_poi, 192);
  sum_used_rows := calc_sum_used_rows(biggestptn + 1);

  writeln('raw compressed patterndata size: ', sum_used_rows * 3, ' bytes');
  writeln('used rows bit index size: ', (biggestptn + 1) shl 3, ' bytes');
  writeln('compressed pattern offset table: ', (biggestptn + 1) shl 1, ' bytes');
  writeln('compressed pattern row counter table: ', biggestptn + 1, ' bytes');

  getmem(pdata_poi, sum_used_rows * 3);
  alloc_heap[7] := sum_used_rows * 3;
  getmem(pat_tmp_poi, 192);
  seek(f, file_patpos);
  patofs := 0;
  for a := 0 to nptns - 1 do
  begin
    write_pdat_ofstab(ptnmap^[a], patofs);
    blockread(f, pat_tmp_poi^, 192);
    patofs := copy_only_used_rows(pat_tmp_poi, patofs);
  end;
  freemem(pat_tmp_poi, 192);
  getmem(ins_poi, {(biggestins+1)}33 * 11);
  alloc_heap[8] := {(biggestins+1)}33 * 11;
{ derzeit noch statisch da Player ins^[32] bentigt, lsst sich evtl. ndern }

  for a := 0 to ninstrs - 1 do blockread(f, ins^[insmap^[a]], 11);


  writeln(filenm, ' file size: ', filesize(f));
  close(f);


  speed := 6; edpos := 0; edrow := 0; edrowjump := true;
  with ins^[32] do
  begin
    lev1 := $3F; lev2 := $3F; atd1 := $0F;
    atd2 := $0F; sur1 := $0F; sur2 := $0F;
  end;

  usedheapmem := 0; for a := 1 to 8 do inc(usedheapmem, alloc_heap[a]);
  writeln('Heap used: ', usedheapmem, ' bytes');
  writeln('Memory used in EMS would be: ', (biggestptn + 1) * 64 * 5, ' bytes');


end; { loadmod }


procedure free_mod;
begin
  freemem(ins_poi, alloc_heap[8]);
  freemem(pdata_poi, alloc_heap[7]);
  freemem(cmppat_row_poi, alloc_heap[6]);
  freemem(pdat_ofstab_poi, alloc_heap[5]);
  freemem(rowidx_poi, alloc_heap[4]);
  freemem(ordr_poi, alloc_heap[3]);
  freemem(insmap_poi, alloc_heap[2]);
  freemem(ptnmap_poi, alloc_heap[1]);
end;


procedure settimerfrq (hz: longint);
  var cnt: longint;
begin
  asm
    mov dx, 043h
    mov al, 034h
    out dx, al
  end;
  if hz = 0 then
  asm
    mov dx, 040h
    xor al, al
    out dx, al
    out dx, al
  end
  else
  begin
    cnt := $1234DD div hz;
    asm
      db 66h; mov bx, word ptr cnt
      mov dx, 040h
      mov al, bl
      out dx, al
      mov al, bh
      out dx, al
    end;
  end;
end;

procedure playmod(position, row: integer);
  var v: byte;
begin
  edpos := position;
  edrow := row;
  edrowjump := true;
  for v := 0 to 8 do
    vocini[v] := -1;
  posjmp := -1;
  ptnbrk := -1;
  e6x := 0; { e6 }
  {
  on timer(1) gosub bt.play
  timer on
  settimerfrq 911
  }
end;


procedure stopmod;
  var v: byte;
begin
  settimerfrq(0);
  { timer off }
  for v := 0 to 8 do
  begin
    opl_setinstr(v, ins^[32]);
    vocini[v] := 32;
    opl_out($B0 + v, 0);
  end;
end;


begin
  clrscr;
  loadmod('zeldni.pis');


  playmod(0,0);

  while not keypressed do
  begin
    gotoxy(4, 10); write('pos: ', edpos:3, '  row: ', edrow:2);
    bt_play_int;
    delay(20);
  end;
  stopmod;

  free_mod;
end.