{$G+}
unit playzsm3;

interface


function load_zsm(name: string): byte; (* Laedt ein ZSTM *)
procedure clear_zsm; (* Gibt den Speicher wieder frei und setzt Werte auf 0 *)
procedure goto_sequ(num: word);
procedure read_row;
procedure init_zsm_soundbuffer(size: word);
procedure fill_soundbuffer;
procedure calc_pattern_sizes;
procedure inc_sequ;
procedure dec_sequ;


function patternpos: word;

type zsm_header = record
  kennung: longint; (* $4D54535A "ZSTM" *)
  version: byte;
  titel: array[0..19] of char;
  composer: array[0..19] of char;
  sample_entries: byte;
  sequencer_entries: word;
  sequencer_loopstart: word;
  sequencer_loopend: word;
  patterndata_size: word;
end;
var
  pattheaderandtables: word;
  patternrowstotal: byte;
  patternrow_act: byte;
  chan_event: array[0..15] of bytebool;
  ptablesize: word;
  smpblocksize: longint;

  actual_sequ: word;
  zsmheader: zsm_header;

  offset_in_patterndata: word;
  smallest_pattern: word;
  biggest_pattern: word;
  number_of_patterns: word;

  act_pattern_number: word;
  act_pattern_size: word;

  actual_spl_per_row: word;

  mixvol: byte;

  vumeter: word;

  trk_active: array[0..15] of bytebool;

  track_select: array[0..15] of bytebool;

  zsmfilesize: longint;

  play_sample: array[0..15] of bytebool;

  emptyflagbits: word;
  purebits: word;
  pattdisp: array[0..23, 0..15] of byte;
  npattline: array[0..15] of byte;
  maxtracks: byte;
  scope_ptr: pointer;
  scopemode: bytebool;

  sync: array[0..255] of byte;


procedure new_pattline;

implementation

uses sblaster;


type smp_info = record
  length: word;
  loopstart: word;
  marker: byte;
end;


type fixkomma = record
  vor: byte;
  nach: word;
end;

type fixkomma_32bit = record
  vor: word;
  nach: word;
end;


type pitch_table = array[0..32 * 63 - 1] of fixkomma;

type seq_struc = array[1..1024] of word;

type byte_struc = array[0..65527] of byte;

type shortint_struc = array[0..65527] of shortint;

type integer_struc = array[0..32766] of word;

type pattern_header = record
  rows: byte;
  spl_per_row: word;
  tracks_active: word;
end;

type pattern_event = record
  smp: byte;
  fixvor: byte;
  fixnach: word;
  vol: byte;
  event: bytebool;
end;

type repeat_data = record
  smp: byte;
  fixvor: byte;
  fixnach: word;
end;


var
  smpinfo: array[1..63] of smp_info;
  pitch_table_len: array [1..63] of byte;
  pitch_table_offset: array [1..63] of word;
  pitch_tables_pointer: pointer;
  pitch_tables: ^pitch_table absolute pitch_tables_pointer;
  pitch_tables_bytesize: word;
  sequencer_pointer: pointer;
  sequencer: ^seq_struc absolute sequencer_pointer;
  patterndata_pointer: pointer;
  patterndata: ^byte_struc absolute patterndata_pointer;
  sample_pointer: array[1..63] of pointer;
  smp_pointer: pointer;
  onesample: ^shortint_struc absolute smp_pointer;
  bitread_pos: longint;
  patternheader: pattern_header;
  {trk_active: array[0..7] of bytebool;}
  onlyvol_exist: array[0..15] of bytebool;
  actual_row: byte;
{  actual_sequ: word;}
{  actual_spl_per_row: word;}
  reg_cx: word;

  sampnr_table_len: array[0..15] of byte;
  sampnr_table: array[0..15, 0..15] of byte;
  volume_table_len: array[0..15] of byte;
  volume_table: array[0..15, 0..7] of byte;
  do_repeat: array[0..15] of bytebool;
  use_emptyrow_flags: bytebool;
  row: byte;
  pattern_row: array[0..15] of pattern_event;
  last_pattern_row: array[0..15] of repeat_data;
  s_pos: fixkomma_32bit;
  s_speed: fixkomma_32bit;
  smp_position: array[0..15] of fixkomma_32bit;
  actual_smplen: word;
  play_sample_actual: bytebool;
  actual_chan_vol: byte;
  actual_sample_loopstart: word;
  fill_length: word;

  play_sample_looped: array[0..15] of bytebool;

  spl_pos_in_row: word;

  row_countdown: word;
  mix_position: word;

  soundbuffer16bit_pointer: pointer;
  soundbuffer16bit: ^integer_struc absolute soundbuffer16bit_pointer;
  soundbuffer_size: word;
  soundbuffer8bit_pointer: pointer;


  pattern_size_table_pointer: pointer;
  pattern_size_table: ^seq_struc absolute pattern_size_table_pointer;


  const
    bitsneeded: array[0..256] of byte =
      (0,0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,
      5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,
      6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
      6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8);


procedure new_pattline;
  var
    i: byte;
begin

  for i := 23 downto 1 do
    move(pattdisp[i-1, 0], pattdisp[i, 0], 16);
  move(npattline, pattdisp, 16);

end;

function load_zsm(name: string): byte;
var
  f: file;
  i: byte;
  {s: string;}  (* nur zum Test *)
  counter: word;
label skip;
begin
  load_zsm := 0;
  assign(f, name);
  {$I-}
  reset(f, 1);
  {$I+}
  if ioresult <> 0 then
  begin
    load_zsm := 1;
    goto skip;
  end;

  maxtracks := 0;


  zsmfilesize := 0;

  (* Header *)
  blockread(f, zsmheader, sizeof(zsmheader));
  if zsmheader.kennung <> $4D54535A then
  begin
    close(f);
    load_zsm := 2;
    goto skip;
  end;
  inc(zsmfilesize, sizeof(zsmheader));


  (* Sample Laengen, Schleifen, Marker *)
  blockread(f, smpinfo, zsmheader.sample_entries * 5);
  inc(zsmfilesize, zsmheader.sample_entries * 5);

  smpblocksize := 0;
  for i := 1 to zsmheader.sample_entries do
    inc(smpblocksize, smpinfo[i].length);
  inc(zsmfilesize, smpblocksize);

  (* Pitch Tabellen *)
  blockread(f, pitch_table_len, zsmheader.sample_entries);
  inc(zsmfilesize, zsmheader.sample_entries);
  counter := 0;
  for i := 1 to zsmheader.sample_entries do
  begin
    pitch_table_offset[i] := counter div 3;
    inc(counter, pitch_table_len[i] * 3);
  end;
  pitch_tables_bytesize := counter;
  ptablesize := counter;
  getmem(pitch_tables_pointer, counter);
  blockread(f, pitch_tables^, counter);
  inc(zsmfilesize, counter);

  (* Sequencer *)
  getmem(sequencer_pointer, zsmheader.sequencer_entries * 2);
  blockread(f, sequencer^, zsmheader.sequencer_entries * 2);
  inc(zsmfilesize, zsmheader.sequencer_entries * 2);

  if zsmheader.sequencer_loopstart < 1 then zsmheader.sequencer_loopstart
    := 1;
  if zsmheader.sequencer_loopstart > zsmheader.sequencer_entries then
    zsmheader.sequencer_loopstart := zsmheader.sequencer_entries;

  if zsmheader.sequencer_loopend < zsmheader.sequencer_loopstart then
    zsmheader.sequencer_loopend := zsmheader.sequencer_loopstart;
  if zsmheader.sequencer_loopend > zsmheader.sequencer_entries then
    zsmheader.sequencer_loopend := zsmheader.sequencer_entries;


  (* Patterns *)
  getmem(patterndata_pointer, zsmheader.patterndata_size);
  blockread(f, patterndata^, zsmheader.patterndata_size);
  inc(zsmfilesize, zsmheader.patterndata_size);

  (* Samples *)
  for i := 1 to zsmheader.sample_entries do
  begin
    getmem(sample_pointer[i], smpinfo[i].length);
    blockread(f, sample_pointer[i]^, smpinfo[i].length);
  end;

  close(f);


  skip:

  actual_spl_per_row := 2646;

end;



procedure clear_zsm;
  var i: byte;
begin

  for i := 1 to zsmheader.sample_entries do
  begin;
    freemem(sample_pointer[i], smpinfo[i].length);
    smpinfo[i].length := 0;
    smpinfo[i].loopstart := 0;
  end;

  freemem(patterndata_pointer, zsmheader.patterndata_size);
  freemem(sequencer_pointer, zsmheader.sequencer_entries * 2);
  freemem(pitch_tables_pointer, pitch_tables_bytesize);

  with zsmheader do
  begin
    fillchar(titel, 20, 0);
    sample_entries := 0;
    sequencer_entries := 0;
    sequencer_loopstart := 0;
    sequencer_loopend := 0;
    patterndata_size := 0;
  end;

end;



function readbits(length: byte): byte; assembler;
asm

  mov dl, length

  les di, patterndata_pointer

  (* 32 Bit Bitposition einlesen und auch in CX uebergeben *)
  db 66h; mov bx, word ptr bitread_pos { mov ebx, bitpos_asm }
  db 66h; mov cx, bx  { mov ecx, ebx }

  (* EBX durch 8 teilen, WORD einlesen *)
  db 66h; shr bx, 3 { shr ebx, 3 }
  mov ax, es:[di+bx]

  (* Modulo Wert erzeugen bzw. in DL steht hiernach der Bitoffset *)
  db 66h; shl bx, 3  { shl ebx, 3 }
  db 66h; sub cx, bx { sub ecx, ebx }

  (* zurechtschieben, Bitoffset elimieren *)
  shr ax, cl
  (* zu lesende Bits befinden sich nun nur noch in AL *)

  (* Maske anwenden *)
  mov cl, dl
  mov ch, 1
  shl ch, cl
  dec ch
  and al, ch

  (* bitposition weiterzaehlen *)
  db 66h; xor cx, cx
  mov cl, dl
  db 66h; add word ptr bitread_pos, cx { add bitread_pos, ecx }
end;






procedure goto_sequ(num: word);
  var
    track, i: byte;
    ii: word;
begin
  actual_sequ := num;

  bitread_pos := sequencer^[num] * 8;

  pattheaderandtables := sequencer^[num];

  offset_in_patterndata := sequencer^[num];


  (* Pattern Header, Tabellen etc. einlesen *)
  move(patterndata^[bitread_pos div 8], patternheader, 5); (* Header *)
  inc(bitread_pos, 5 * 8); (* Header eingelesen, also ueberspringen *)


  patternrowstotal := patternheader.rows;
  ii := 0;
  repeat inc(ii) until sequencer^[num] = pattern_size_table^[ii];
  act_pattern_number := ii;
  act_pattern_size := pattern_size_table^[ii+1]-pattern_size_table^[ii];

  purebits := 0;
  emptyflagbits := 0;


  (* Aktive-Tracks Flags einlesen *)
  for track := 0 to 15 do
    if patternheader.tracks_active and (1 shl track) > 0 then
    begin
      trk_active[track] := true;
      if track > maxtracks then maxtracks := track;
    end
    else
      trk_active[track] := false;

  (* Tabellen einlesen *)
  for track := 0 to 15 do if trk_active[track] then
  begin

    if readbits(1) > 0 then
    begin

      sampnr_table_len[track] := readbits(bitsneeded[zsmheader.sample_entries+1]);
      inc(sampnr_table_len[track]);
 (*****************************************************)
      for i := 1 to sampnr_table_len[track] do
        sampnr_table[track, i-1] := readbits(bitsneeded[zsmheader.sample_entries+1]);
    end
    else
      sampnr_table_len[track] := 0;


    volume_table_len[track] := readbits(3);
    inc(volume_table_len[track]);
    for i := 1 to volume_table_len[track] do
      volume_table[track, i-1] := readbits(3);

    if readbits(1) = 0 then
      do_repeat[track] := false else do_repeat[track] := true;

    if readbits(1) = 0 then onlyvol_exist[track] := false
      else onlyvol_exist[track] := true;

  end;

  if readbits(1) = 1 then use_emptyrow_flags := true else use_emptyrow_flags := false;



  actual_row := 0;

  if patternheader.spl_per_row > 0 then
    actual_spl_per_row := patternheader.spl_per_row;
  if patternheader.spl_per_row = 0 then
    patternheader.spl_per_row := actual_spl_per_row;

  pattheaderandtables := bitread_pos div 8 - pattheaderandtables;

end;


procedure goto_next_sequ;
begin

  inc(actual_sequ);
  if actual_sequ > zsmheader.sequencer_loopend then
    actual_sequ := zsmheader.sequencer_loopstart;
  goto_sequ(actual_sequ);

end;



procedure read_row;
  var
    track, tblpos, i: byte;
    read_onlyvol: bytebool;
  label
    skip, skip2;
begin

  patternrow_act := actual_row;

  fillchar(npattline, 16, 0);

  fillchar(sync, 256, 0);

  if use_emptyrow_flags then inc(emptyflagbits);

  for track := 0 to 15 do
    pattern_row[track].event := false;


  (* Leerzeilen Flag optional *)
  if use_emptyrow_flags then if readbits(1) = 0 then goto skip2;

  for track := 0 to 15 do
  if trk_active[track] then (* nur aktive Kanaele abfragen *)
  if readbits(1) = 1 then (* Wenn Event auf Kanal stattfindet *)
  begin
    pattern_row[track].event := true; (* Event markieren *)

    inc(emptyflagbits);

    (* Bei nur Lautstaerke nicht triggern *)
    read_onlyvol := false;
    if onlyvol_exist[track] then
    begin
    inc(purebits);
    if readbits(1) = 0 then
    begin
      read_onlyvol := true;
      goto skip
    end;
    end;
     fillchar(smp_position[track], 4, 0); (* triggern *)

    (* Repeat abfragen, falls genutzt *)
    if do_repeat[track] then
    begin
     inc(purebits);
     if readbits(1) = 1 then
     begin
       pattern_row[track].smp := last_pattern_row[track].smp;
       pattern_row[track].fixvor := last_pattern_row[track].fixvor;
       pattern_row[track].fixnach := last_pattern_row[track].fixnach;
       goto skip;
     end
    end;

     (* Sampnr *)
     if sampnr_table_len[track] = 0 then
     begin
       inc(purebits, bitsneeded[zsmheader.sample_entries+1]);
       pattern_row[track].smp := readbits(bitsneeded[zsmheader.sample_entries+1])
     end
     else
     begin
       inc(purebits, bitsneeded[sampnr_table_len[track]]);
       pattern_row[track].smp
         := sampnr_table[track, readbits(bitsneeded[sampnr_table_len[track]])];
     end; (* SampNr 0 zusammen mit event bedeutet Sample Stop *)

     (* Pitch *)
     if pattern_row[track].smp > 0 then
     begin
       tblpos := readbits(bitsneeded[pitch_table_len[pattern_row[track].smp]]);

       inc(purebits, bitsneeded[pitch_table_len[pattern_row[track].smp]]);

       move(pitch_tables^[pitch_table_offset[pattern_row[track].smp] + tblpos],
         pattern_row[track].fixvor, 3);

     end;

     if pattern_row[track].smp > 0 then
       move(pattern_row[track], last_pattern_row[track], 4);

     skip:

     if (pattern_row[track].smp > 0) or read_onlyvol then
     begin
       pattern_row[track].vol
        := volume_table[track, readbits(bitsneeded[volume_table_len[track]])];
       inc(purebits, bitsneeded[volume_table_len[track]]);
     end;

    play_sample_looped[track] :=  smpinfo[pattern_row[track].smp].loopstart
       < smpinfo[pattern_row[track].smp].length;

  end;

  skip2:

  for track := 0 to 15 do (* Nur fr den Player als Anzeige *)
    chan_event[track] := pattern_row[track].event;

  for track := 0 to 15 do
  begin
    if pattern_row[track].event then
      npattline[track] := pattern_row[track].vol;
    if pattern_row[track].event and (pattern_row[track].smp = 0) then
      npattline[track] := 0;
    {
    if trk_active[track] and (actual_row = 0) and
    (pattern_row[track].smp > 0) and pattern_row[track].event then inc(npattline[track], 8);
    end;
    }
    if actual_row = 0 then inc(npattline[track], 8);

   end;


   for track := 0 to 15 do
   if trk_active[track] then
   if pattern_row[track].event then
     for i := 1 to zsmheader.sample_entries do
       sync[smpinfo[pattern_row[track].smp].marker]
         := pattern_row[track].vol;

  new_pattline;

  inc(actual_row);

end;



procedure mix_in_channel_sloop; assembler;
asm

  db 66h; mov bx, word ptr s_pos
  db 66h; mov dx, word ptr s_speed
  mov cx, ds; lds si, smp_pointer; mov ax, ds; mov ds, cx
  db 8eh; db 0e0h { mov fs, ax }
  les di, soundbuffer16bit_pointer
  mov ax, mix_position
  add ax, ax { SHL AX, 1 }
  add di, ax
  (* es:[di] zeigt nun auf die richtige Mixposition *)

  db 66h; shl ax, 16
  mov ax, actual_sample_loopstart

  push bp
  mov bp, actual_sample_loopstart
  db 66h; shl bp, 16
  mov bp, actual_smplen

  db 66h; ror di, 16
  mov di, fill_length
  dec di
  db 66h; ror di, 16
  mov cx, 0ffffh
  db 66h; shl cx, 16
  mov cx, 2


  mov al, actual_chan_vol
  cmp al, 7; je @loopvol7
  cmp al, 6; je @loopvol6
  cmp al, 5; je @loopvol5
  cmp al, 4; je @loopvol4
  cmp al, 3; je @loopvol3
  cmp al, 2; je @loopvol2
  cmp al, 1; je @loopvol1

  @loopvol0:
  cmp bx, bp; jb @skipvol0
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol0:; db 64h; mov ah, ds:[si+bx]
  sar ax, 10; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol0; jmp @end

  @loopvol1:
  cmp bx, bp; jb @skipvol1
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol1:; db 64h; mov ah, ds:[si+bx]
  sar ax, 9; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol1; jmp @end

  @loopvol2:
  cmp bx, bp; jb @skipvol2
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol2:; db 64h; mov ah, ds:[si+bx]
  sar ax, 8; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol2; jmp @end

  @loopvol3:
  cmp bx, bp; jb @skipvol3
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol3:; db 64h; mov ah, ds:[si+bx]
  sar ax, 7; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol3; jmp @end

  @loopvol4:
  cmp bx, bp; jb @skipvol4
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol4:; db 64h; mov ah, ds:[si+bx]
  sar ax, 6; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol4; jmp @end

  @loopvol5:
  cmp bx, bp; jb @skipvol5
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol5:; db 64h; mov ah, ds:[si+bx]
  sar ax, 5; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol5; jmp @end

  @loopvol6:
  cmp bx, bp; jb @skipvol6
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol6:; db 64h; mov ah, ds:[si+bx]
  sar ax, 4; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol6; jmp @end

  @loopvol7:
  cmp bx, bp; jb @skipvol7
  db 66h; ror bp, 16; mov bx, bp; db 66h; ror bp, 16
  db 66h; add bx, dx; adc bx, 0
  @skipvol7:; db 64h; mov ah, ds:[si+bx]
  sar ax, 3; add es:[di], ax
  db 66h; add bx, dx; adc bx, 0
  db 66h; add di, cx
  jc @loopvol7;

  @end:

  pop bp
  db 66h; mov word ptr s_pos, bx

end;




procedure mix_in_channel; assembler;
asm

  db 66h; mov bx, word ptr s_pos
  db 66h; mov dx, word ptr s_speed

  mov cx, ds; lds si, smp_pointer; mov ax, ds; mov ds, cx
  db 8eh; db 0e0h { mov fs, ax }
  les di, soundbuffer16bit_pointer
  mov ax, mix_position
  add ax, ax { shl ax, 1 }
  add di, ax
  (* es:[di] zeigt nun auf die richtige Mixposition *)
  (* fs:[si] zeigt auf Sampledaten *)

  push bp

  mov ax, actual_smplen

  cmp bx, ax
  jnb @end

  db 66h; or dx, dx
  jz @end (* Wenn Speed = 0, nichts zu berechnen *)

  mov play_sample_actual, 0

  sub ax, bx (* Rest von abzuspielendem Sample berechnen *)
  dec ax
  db 66h; shl ax, 16
  db 66h; mov bp, dx
  db 66h; xor dx, dx
  db 66h; ror bp, 16
  db 66h; div bp
  (* in EAX steht nun die Laenge, *)
  (* die verarbeitet werden kann, *)
  (* ohne das Sample-Ende zu ueberschreiten *)
  db 66h; mov dx, bp
  db 66h; ror dx, 16

  db 66h; or ax, ax (* Wenn EAX 0 dann nichts zu berechnen *)
  jz @end

  db 66h; xor bp, bp
  mov bp, fill_length

  db 66h; cmp ax, bp
  jbe @below
  mov ax, bp
  mov play_sample_actual, 0ffh
  @below:

  db 66h; ror di, 16
  mov di, ax
  dec di
  db 66h; ror di, 16
  mov cx, 0ffffh
  db 66h; shl cx, 16
  mov cx, 2
  xor bp, bp


  mov al, actual_chan_vol
  cmp al, 7; je @loopvol7
  cmp al, 6; je @loopvol6
  cmp al, 5; je @loopvol5
  cmp al, 4; je @loopvol4
  cmp al, 3; je @loopvol3
  cmp al, 2; je @loopvol2
  cmp al, 1; je @loopvol1

  @loopvol0:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 10; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol0; jmp @end

  @loopvol1:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 9; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol1; jmp @end

  @loopvol2:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 8; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol2; jmp @end

  @loopvol3:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 7; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol3; jmp @end

  @loopvol4:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 6; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol4; jmp @end


  @loopvol5:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 5; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol5; jmp @end


  @loopvol6:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 4; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol6; jmp @end

  @loopvol7:
  db 64h; mov ah, ds:[si+bx];
  sar ax, 3; add es:[di], ax
  db 66h; add bx, dx; adc bx, bp
  db 66h; add di, cx
  jc @loopvol7


  @end:
  pop bp
  db 66h; mov word ptr s_pos, bx

end;

procedure mix_in_channels;
  var
    track: byte;
begin

  for track := 0 to 15 do
  begin
  if play_sample[track] and track_select[track] then
  begin
    play_sample_actual := true;

    smp_pointer := sample_pointer[pattern_row[track].smp];

    s_pos := smp_position[track];
    s_speed.vor := pattern_row[track].fixvor;
    s_speed.nach := pattern_row[track].fixnach;

    actual_smplen := smpinfo[pattern_row[track].smp].length;
    actual_chan_vol := pattern_row[track].vol;

    actual_sample_loopstart := smpinfo[pattern_row[track].smp].loopstart;

    if play_sample_looped[track] then
      mix_in_channel_sloop else mix_in_channel;

    smp_position[track] := s_pos;

    play_sample[track] := play_sample_actual;
  end;
  end; { for track }

  inc(mix_position, fill_length);

end;




procedure make_8bit_buffer_vol2; assembler;
asm

  mov cx, soundbuffer_size

  les di, soundbuffer8bit_pointer

  push ds
  lds si, soundbuffer16bit_pointer


  mov dx, -256
  mov bx, 255

  @loopstart:

  mov ax, ds:[si]
  sar ax, 6



  (* positiv: wenn ah = 0 ist kein Clipping *)

  (* negativ: wenn ah + 1 = 0 ist kein Clipping *)

  or ah, ah
  jz @skip2 (* kein Clipping *)
  js @negativ (* moegl. negatives Clipping *)
  mov ax, bx (* pos. Clipping *)
  jmp @skip2
  @negativ:
  inc ah
  jz @skip
  mov ax, dx
  jmp @skip2
  @skip:
  dec ah
  @skip2:
  sar ax, 1


  add al, 128 (* zu vorzeichenlos konvertieren *)
  mov es:[di], al

  add si, 2
  inc di

  dec cx
  jnz @loopstart

  pop ds
end;


procedure make_8bit_buffer_vol1; assembler;
asm

  mov cx, soundbuffer_size

  les di, soundbuffer8bit_pointer

  push ds
  lds si, soundbuffer16bit_pointer


  mov dx, -256
  mov bx, 255

  @loopstart:

  mov ax, ds:[si]
  sar ax, 5


  or ah, ah
  jz @skip2 (* kein Clipping *)
  js @negativ (* moegl. negatives Clipping *)
  mov ax, bx (* pos. Clipping *)
  jmp @skip2
  @negativ:
  inc ah
  jz @skip
  mov ax, dx
  jmp @skip2
  @skip:
  dec ah
  @skip2:
  sar ax, 1



  add al, 128 (* zu vorzeichenlos konvertieren *)
  mov es:[di], al

  add si, 2
  inc di

  dec cx
  jnz @loopstart

  pop ds
end;

procedure make_8bit_buffer_vol0; assembler;
asm

  mov cx, soundbuffer_size

  les di, soundbuffer8bit_pointer

  push ds
  lds si, soundbuffer16bit_pointer


  mov dx, -256
  mov bx, 255

  @loopstart:

  mov ax, ds:[si]
  sar ax, 4


  or ah, ah
  jz @skip2 (* kein Clipping *)
  js @negativ (* moegl. negatives Clipping *)
  mov ax, bx (* pos. Clipping *)
  jmp @skip2
  @negativ:
  inc ah
  jz @skip
  mov ax, dx
  jmp @skip2
  @skip:
  dec ah
  @skip2:
  sar ax, 1


  add al, 128 (* zu vorzeichenlos konvertieren *)
  mov es:[di], al

  add si, 2
  inc di

  dec cx
  jnz @loopstart

  pop ds
end;


procedure get_vumeter; assembler;
asm

  les si, soundbuffer16bit_pointer

  mov cx, soundbuffer_size
  shr cx, 2
  xor bx, bx
  xor dx, dx

  @loopstart:

    mov ax, es:[si]

    cmp ax, bx
    jge @2
    neg ax
    @2:

    cmp ax, dx
    jbe @3
    mov dx, ax
    @3:

    add si, 8


  dec cx
  jnz @loopstart

  shr dx, 4

  mov vumeter, dx

end;


procedure get_scope; assembler;
asm
  mov dx, soundbuffer_size
  shr dx, 8

  mov cx, 256

  les di, scope_ptr
  push ds; lds si, soundbuffer8bit_pointer

  @loop:
  mov al, ds:[si]
  shr al, 1
  stosb
  add si, dx

  dec cx; jnz @loop

  pop ds
end;


procedure fill_soundbuffer; (* beim erstmaligen Aufruf row_countdown = 0 *)
  var
    buffercountdown: word;
    track: byte;
  label
    skip;
begin

  fillchar(soundbuffer16bit^, soundbuffer_size shl 1, 0);

  mix_position := 0;
  buffercountdown := soundbuffer_size;

  if row_countdown > soundbuffer_size then
  begin
    fill_length := soundbuffer_size;
    mix_in_channels;
    dec(row_countdown, fill_length);
    goto skip;
  end;


  while buffercountdown >= row_countdown do
  begin
    fill_length := row_countdown;
    mix_in_channels;
    dec(buffercountdown, fill_length);
    if actual_row = patternheader.rows + 1 then goto_next_sequ;

    read_row;
    row_countdown := patternheader.spl_per_row;

    for track := 0 to 15 do (* Bestimmen ob Sample gespielt wird *)
      if pattern_row[track].event then
        if pattern_row[track].smp > 0 then
          play_sample[track] := true
        else
          play_sample[track] := false;

  end;


  if buffercountdown > 0 then
  begin
    fill_length := buffercountdown;
    mix_in_channels;
    dec(row_countdown, fill_length);
  end;


  skip:
(* Puffer gefuellt *)


  if scopemode then get_scope;
  get_vumeter;
{  if not scopemode then get_vumeter;}

  vumeter := vumeter div (1 shl mixvol);
{  if vumeter < 1 then vumeter := 1;}

  soundbuffer8bit_pointer := doublebuffer;
  if mixvol = 1 then
    make_8bit_buffer_vol1
  else
  if mixvol = 2 then
    make_8bit_buffer_vol2
  else
    make_8bit_buffer_vol0;

end;


procedure init_zsm_soundbuffer(size: word);
begin
  getmem(soundbuffer16bit_pointer, size*2); { 16 Bit Soundpuffer }
  soundbuffer_size := size;

  mixvol := 1;

  getmem(scope_ptr, 256);
  fillchar(scope_ptr^, 256, 64);
  {
  0 = 0 dB
  1 = -6 dB
  2 = -12 dB
  }
end;


function patternpos: word;
begin
  patternpos
    := bitread_pos div 8 - sequencer^[actual_sequ] - pattheaderandtables;
end;


procedure calc_pattern_sizes;
  var
    i, ii: word;
    swapbuf: word;
    swapped: bytebool;
    listlen: word;
begin
  getmem(pattern_size_table_pointer, 2048);

  move(sequencer^, pattern_size_table^, zsmheader.sequencer_entries * 2);

  swapped := true;
  while swapped do

  begin
    swapped := false;
  for i := 1 to zsmheader.sequencer_entries - 1 do
    if pattern_size_table^[i] > pattern_size_table^[i+1] then
    begin
      swapped := true;
      swapbuf := pattern_size_table^[i];
      pattern_size_table^[i] := pattern_size_table^[i+1];
      pattern_size_table^[i+1] := swapbuf;
    end;

   end;

  listlen := zsmheader.sequencer_entries;


  (* gleiche aufeinanderfolgende entfernen *)

  i := 1;
  for ii := 1 to listlen do
  begin
    if pattern_size_table^[i] <> pattern_size_table^[ii] then inc(i);
    pattern_size_table^[i] := pattern_size_table^[ii];
  end;
  listlen := i;

  pattern_size_table^[listlen+1] := zsmheader.patterndata_size;

  {
  smallest_pattern: word;
  biggest_pattern: word;
  }
  number_of_patterns := listlen;

  smallest_pattern := 65535;
  for i := 1 to listlen do
    if pattern_size_table^[i+1]-pattern_size_table^[i] < smallest_pattern then
      smallest_pattern := pattern_size_table^[i+1]-pattern_size_table^[i];


  biggest_pattern := 0;
  for i := 1 to listlen do
    if pattern_size_table^[i+1]-pattern_size_table^[i] > biggest_pattern then
      biggest_pattern := pattern_size_table^[i+1]-pattern_size_table^[i];


   for i := 1 to listlen do
     writeln(pattern_size_table^[i]);

  {freemem(pattern_size_table_pointer, 2048);}
end;

procedure inc_sequ;
begin
  if actual_sequ < zsmheader.sequencer_entries then
  begin
    inc(actual_sequ);
    goto_sequ(actual_sequ);
  end;
end;


procedure dec_sequ;
begin
  if actual_sequ > 1 then
  begin
    dec(actual_sequ);
    goto_sequ(actual_sequ);
  end;
end;

end.