unit sblaster;

interface

function init_sound(bufsize: word): byte;
procedure deinit_sound;
function doublebuffer: pointer;

var
  sound_nextframe: bytebool;


implementation

uses dos, crt;

var

  sb_base: word;
  sb_irq, sb_dma: byte;

  soundbuf_byte: array[0..1] of pointer;
  linear_bufaddr: array[0..1] of longint;
  old_intvec: pointer;
  soundbuf_which: byte;
  portaddr: array[1..2] of byte;
  portval: array[1..2, 0..1] of byte;
  port_0ah: byte;
  buffersize: word;

const
  pagereg: array[0..3] of byte = ($87, $83, $81, $82);

function hexchar2nibble(c: char): longint;
begin
  if ord(c) < 65
    then
      hexchar2nibble := ord(c)-48
    else
      hexchar2nibble := ord(c)-55;
end;


function read_dsp: byte;
begin
  repeat until (port[sb_base+14] and 128) = 128;
  read_dsp := port[sb_base+10];
end;
procedure write_dsp(value: byte);
begin
  repeat until (port[sb_base + 12] and 128) = 0;
  port[sb_base + 12] := value;
end;


procedure program_dma_and_dsp2;
begin
  port[portaddr[1]] := portval[1, soundbuf_which];
  port[portaddr[1]] := portval[2, soundbuf_which];
  port[portaddr[2]] := lo(buffersize-1);
  port[portaddr[2]] := hi(buffersize-1);
  port[$0A] := port_0ah;

  write_dsp($14);
  write_dsp(lo(buffersize-1));
  write_dsp(hi(buffersize-1));
end;


procedure sb_int_rout;
interrupt;
  var dummy: byte;
begin
  program_dma_and_dsp2;
  if soundbuf_which = 1 then soundbuf_which := 0 else soundbuf_which := 1;
  sound_nextframe := true;
  dummy := port[sb_base + $00E];
  port[$20] := $20;
end;



procedure program_dma_and_dsp;
begin
  port[$0A] := 4 + (sb_dma mod 4);
  port[$0C] := $FF;
  port[$0B] := $48 + (sb_dma mod 4);
  port[(sb_dma mod 4)*2] := lo(linear_bufaddr[soundbuf_which] mod 65536);
  port[(sb_dma mod 4)*2] := hi(linear_bufaddr[soundbuf_which] mod 65536);
  port[(sb_dma mod 4)*2+1] := lo(buffersize-1);
  port[(sb_dma mod 4)*2+1] := hi(buffersize-1);
  port[pagereg[sb_dma mod 4]] := linear_bufaddr[soundbuf_which] div 65536;
  port[$0A] := (sb_dma mod 4);

  write_dsp($14); write_dsp(lo(buffersize-1)); write_dsp(hi(buffersize-1));

end;


function doublebuffer: pointer;
begin
  doublebuffer := soundbuf_byte[soundbuf_which];
end;


function init_sound(bufsize: word): byte;
var
  sb_env: string;
  i: word;
begin
  {
  Fehlercodes:
  $01 = BLASTER environment variable not found.
  $02 = DSP initialization failed.
  }
  buffersize := bufsize;
  sb_env := getenv('BLASTER');
  if ord(sb_env[0]) = 0 then begin init_sound := 1; exit; end;
  i := 1; while not (sb_env[i] = 'A') do inc(i);
  sb_base := 0; inc(i);
  inc(sb_base, hexchar2nibble(sb_env[i])*256); inc(i);
  inc(sb_base, hexchar2nibble(sb_env[i])*16); inc(i);
  inc(sb_base, hexchar2nibble(sb_env[i])); inc(i);
  while not (sb_env[i] = 'I') do inc(i);
  inc(i); sb_irq := hexchar2nibble(sb_env[i]); inc(i);
  while not (sb_env[i] = 'D') do inc(i);
  inc(i); sb_dma := hexchar2nibble(sb_env[i]);
  {
  }
  port[sb_base + 6] := 1; delay(1); port[sb_base + 6] := 0;
  i := 2000;
  repeat
    if i < 1 then begin init_sound := 2; exit; end;
    dec(i); delay(1);
  until read_dsp = $AA;
  {
  }
  for i := 0 to 1 do
  begin
    getmem(soundbuf_byte[i], bufsize);
    fillchar(soundbuf_byte[i]^, bufsize, 128);
    linear_bufaddr[i] := seg(soundbuf_byte[i]^);
    linear_bufaddr[i] := (linear_bufaddr[i] shl 4) + ofs(soundbuf_byte[i]^);
  end;
  {
  }
  getintvec(sb_irq + 8, old_intvec);
  port[$21] := port[$21] or (1 shl sb_irq);
  asm cli end;
  setintvec(sb_irq + 8, @sb_int_rout);
  port[$21] := port[$21] and (255-(1 shl sb_irq));
  {
  asm sti end;
  }
  {
  }
  write_dsp($D1); (* Lautsprecher einschalten *)
  write_dsp($40); write_dsp(211);
   (* Frequenz auf 22050 Hz einstellen *)
{  sound_nextframe := false;}
  soundbuf_which := 0;
  program_dma_and_dsp;
  {
  }
  portaddr[1] := (sb_dma mod 4) * 2;
  portaddr[2] := (sb_dma mod 4) * 2 + 1;
  portval[1, 0] := lo(linear_bufaddr[0] mod 65536);
  portval[1, 1] := lo(linear_bufaddr[1] mod 65536);
  portval[2, 0] := hi(linear_bufaddr[0] mod 65536);
  portval[2, 1] := hi(linear_bufaddr[1] mod 65536);
  port_0ah := sb_dma mod 4;
  {
  }

  init_sound := 0;

  asm sti end;
end;

procedure deinit_sound;
begin

  write_dsp($D0); (* stop sound immediately *)
  write_dsp($DA); (* stop sound at the end of current block *)

  write_dsp($D3); (* Lautsprecher ausschalten *)

  port[$21] := port[$21] or (1 shl sb_irq);
  asm cli end;
  setintvec(sb_irq+8, old_intvec);
  port[$21] := port[$21] and (255-(1 shl sb_irq));
  asm sti end; (* INT ?? ist jetzt wieder auf der alten Routine *)
end;


end.