{$G+}
uses playzsm3, sblaster, crt;
  var track: byte;
      titel: string[20];
      composer: string[20];
      i: byte;
      fname: string[20];
      key: bytebool;
      ch: char;
      ln10: real;
      lastpatpos: word;
      scopecol: word;
      lastscopecol: byte;
      scopecolchange: bytebool;
      screenbuf: pointer;
      marquee: string;
      marquee_pos: word;
      bitsum: word;
      dancer_dir: shortint;
      dancer_x: byte;
      bufstep: byte;
      dancer_on: bytebool;
      dancer_jump: byte;
      dancer_pose: byte;
      drums_detected: bytebool;
      do_pdisplay: bytebool;
   const bsize = 768;
         flashcol: array[1..6] of byte = (4, 6, 12, 13, 14, 15);
         pattcol: array[0..7] of byte = (0, 1, 1, 9, 2, 3, 10, 11);
         togglekey: array[0..15] of char = '0123456789ABCDEF';
         dancecol: array[0..3] of byte = (11, 3, 9, 1);
         scopetext: string = '-=ZSMPLAY=-';
         scopetext2: string ='scope mode';

procedure display_dancer;
  var y, x: byte;
  pre,pre2, post,post2: string[8];
begin

  if dancer_jump = 3 then
    if dancer_dir < 0 then dancer_pose := 7
    else
    if dancer_dir > 0 then dancer_pose := 8
    else dancer_pose := 10;
  if dancer_jump = 2 then
    dancer_pose := 9;
  if dancer_jump = 3 then
    dancer_pose := 3;
  if dancer_jump = 1 then
    dancer_pose := 11;


  x := 42;

  y := 12;


  pre := '         '; post := pre;

  pre2 := ''; post2 := pre2;

  pre[0] := chr(dancer_x);
  post[0] := chr(6 - dancer_x);
  pre2[0] := chr(dancer_x);
  post2[0] := chr(6 - dancer_x);


  if dancer_pose = 1 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('/\'); write(post);
    gotoxy(x,y+2); write(pre); write('  '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 2 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('<>'); write(post);
    gotoxy(x,y+2); write(pre); write('  '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 3 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('<\'); write(post);
    gotoxy(x,y+2); write(pre); write('  '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;


  if dancer_pose = 4 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('/>'); write(post);
    gotoxy(x,y+2); write(pre); write('  '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 5 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write('\o '); write(post);
    gotoxy(x,y+1); write(pre); write(' \'); write(post);
    gotoxy(x,y+2); write(pre); write('  '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 6 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o/'); write(post);
    gotoxy(x,y+1); write(pre); write('/ '); write(post);
    gotoxy(x,y+2); write(pre); write('  '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;



  if dancer_pose = 7 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('<\'); write(post);
    gotoxy(x,y+2); write(pre); write('< \'); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 8 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('/>'); write(post);
    gotoxy(x,y+2); write(pre); write('/ >'); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 9 then
  begin
    gotoxy(x,y-1); write(pre); write('\o/'); write(post);
    gotoxy(x,y+0); write(pre); write('  '); write(post);
    gotoxy(x,y+1); write(pre); write('/ \'); write(post);
    gotoxy(x,y+2); write(pre); write('   '); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 10 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write(' o '); write(post);
    gotoxy(x,y+1); write(pre); write('/\'); write(post);
    gotoxy(x,y+2); write(pre); write('< >'); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;

  if dancer_pose = 11 then
  begin
    gotoxy(x,y-1); write(pre); write('   '); write(post);
    gotoxy(x,y+0); write(pre); write('   '); write(post);
    gotoxy(x,y+1); write(pre); write(' o '); write(post);
    gotoxy(x,y+2); write(pre); write('/\'); write(post);
    gotoxy(x,y+3); write(pre2); write(''); write(post2);
  end;


end;


procedure display_marquee;
  var
   i: byte;
begin

  gotoxy(42, 9);
    for i := marquee_pos div 3 + 1 to marquee_pos div 3 + 9 do
      write(marquee[i mod ord(marquee[0])+1]);

  if marquee_pos div 3 > ord(marquee[0]) then marquee_pos := 0;

end;

procedure display_vu;
  var i: shortint;
  db: shortint;
  fcol: byte;
  green, yellow, red: byte;
begin

  if vumeter = 0 then db := -128 else
    db := trunc(20 * ln(vumeter / 256) / ln10);


  gotoxy(37, 19);


  if db > 6 then db := 6;

  if db < -33 then begin
   textcolor(3);
   for i := -33 to 6 do write('')
  end
  else
  begin

    if db < 0 then
    begin
    textcolor(10);
      for i := -33 to db do
        write('');
    end;

    if db = 0 then
    begin
    textcolor(10);
      for i := -33 to -1 do
        write('');
    textcolor(14); write('');
    end;

    if db > 0 then
    begin
    textcolor(10);
      for i := -33 to -1 do
        write('');
    textcolor(14); write('');
    textcolor(12);
    for i := 1 to db do
      write('');

    end;

    textcolor(3);
    for i := db+1 to 6 do
      write('');
    textcolor(7);

  end;

  fcol := vumeter div 48;
  if fcol < 1 then fcol := 1;
  if fcol > 6 then fcol := 6;
  textcolor(flashcol[fcol]);
  gotoxy(16, 1); write('-=ZSMPLAY=-');
  textcolor(7);

end;


procedure display_scope; assembler;
asm

          mov ax, 0a000h
          mov es, ax
          mov ax, vumeter
          or ah, ah
          jz @noclip
          mov ax, 255
          @noclip:
          lea bx, dancecol
          shr al, 6
          inc al
          add bx, 4
          sub bx, ax
          mov al, ds:[bx]
          mov ah, al
          mov di, 35*320+32
          mov cx, 128
          rep stosw
          mov di, 164*320+32
          mov cx, 128
          rep stosw

          mov cx, 128
          mov di, 36*320+31
          @loop0:
            mov es:[di], al
            add di, 257
            mov es:[di], al
            add di, 63
          dec cx
          jnz @loop0

          push bp

          lea bp, scopetext2
          inc bp
          mov bx, scopecol
          sub bx, 8
          mov ax, ds
          mov es, ax
          mov ax, 1300h
          mov cx, 10
          mov dh, 21
          mov dl, 15
          int 10h

          lea bp, scopetext
          inc bp
          mov ax, ds
          mov es, ax
          mov ax, 1300h
          mov bx, 23
          sub bx, scopecol
          mov cx, 11
          mov dh, 3
          mov dl, 14
          int 10h

          pop bp

  db 66h; xor cx, cx
  mov bx, scopecol
  les di, screenbuf

  mov dx, di

  db 66h; xor cx, cx
  mov cx, 128*64; db 66h; xor ax, ax
  db 66h; rep stosw { rep stosd }

  mov ax, 1300h
  db 66h; shl ax, 16
  mov ax, 1300h
  mov di, 64*256
  mov cx, 64
  db 66h; rep stosw

  mov di, dx

  push ds
  lds si, scope_ptr

  mov cx, 255; db 66h; shl cx, 16
  mov cx, di; mov dx, 0ffffh
  db 66h; shl dx, 16; mov dx, 1

  @loop:
  lodsb
  shl ax, 8
  mov di, cx
  add di, ax
  mov ax, bx
  mov es:[di], al
  db 66h; add cx, dx
  jc @loop
  pop ds


  push ds
  lds si, screenbuf
  mov ax, 0a000h
  mov es, ax

  mov bx, 128
  mov di, 36*320+32
  @loop2:
    mov cx, 64
    db 66h; rep movsw { rep movsd }
    add di, 64
  dec bx
  jnz @loop2
  pop ds
end;


procedure display_box;
begin
  gotoxy(41, 10); write('Ŀ');
  gotoxy(41, 11); write(''); gotoxy(51, 11); write('');
  gotoxy(41, 12); write(''); gotoxy(51, 12); write('');
  gotoxy(41, 13); write(''); gotoxy(51, 13); write('');
  gotoxy(41, 14); write(''); gotoxy(51, 14); write('');
  gotoxy(41, 15); write(''); gotoxy(51, 15); write('');
end;

procedure display_static;
begin
  textcolor(1);
  display_box;
  gotoxy(42, 9); write('         ');
  gotoxy(44, 13); write('..zZ');
  gotoxy(42, 14); write('o_');
  gotoxy(41, 15); write('');
  gotoxy(42, 16); write('(T)oggle');
  textcolor(4);
  gotoxy(16, 1); write('-=ZSMPLAY=-');
  textcolor(3);write(' v0.03 by Zatzen 2016');
  gotoxy(13, 3); textcolor(9); write('Song Name: ', titel);
  if titel[0] = chr(0) then write ('(none)');
  gotoxy(14, 4);
  write('Composer: ', composer);
  if composer[0] = chr(0) then write('(unknown)');
  textcolor(2);
  gotoxy(36, 17);write('-33   -27   -21   -15   -9    -3  ');
  textcolor(6); write('0    '); textcolor(4); write('+6');
  textcolor(2);
  gotoxy(37, 18); write('                           ');
  textcolor(6); write('     '); textcolor(4);write('');
  textcolor(3);
  gotoxy(37, 19); write('');
  textcolor(2); write(' dB');
  gotoxy(37, 20); write('                            ');
  textcolor(6); write('  '); textcolor(4); write('');
  textcolor(2);
  gotoxy(37, 21); write('  -30   -24   -18   -12   -6     ');
  textcolor(6); write('0 '); textcolor(4); write('+3 ');

  textcolor(2);
  gotoxy(24, 5); write('Sequencer: ');
  gotoxy(26, 6); write('Pattern: ');
  gotoxy(22, 7); write('Pattern Row: ');
  gotoxy(12, 8); write('Offset In Patterndata: ');

  textcolor(3);
  gotoxy(13, 09); write('Pattern Size (Bytes):');
  gotoxy(2, 10); write('Pattern Header & Tables (Bytes):');
  gotoxy(3, 11); write('Position in Patterndata (Byte):');
  gotoxy(3, 12); write('Avg. Bits/Row:       Bytes/Sec: ');
  textcolor(8);
  gotoxy(16, 13); write('Event Flags Bytes:');
  gotoxy(2, 14); write('Ratio:');
  textcolor(7);
  gotoxy(12, 14); write('Pure Music Data Bytes:');
  {
  textcolor(8);
  gotoxy(28, 16); write('% Flags:');
  }
  textcolor(8);
  gotoxy(1, 16);
  writeln('File: ', fname);
  writeln('Size: ', zsmfilesize, ' Bytes');
  writeln('Patterndata Size Total: ', zsmheader.patterndata_size, ' Bytes');
  writeln('Biggest Pattern: ', biggest_pattern, ' Bytes');
  writeln('Smallest Pattern: ', smallest_pattern, ' Bytes');
  writeln('Average Pattern Size: ', zsmheader.patterndata_size div number_of_patterns, ' Bytes');
  writeln('Samples: ', zsmheader.sample_entries);
  writeln('Pitch Tables Size: ', ptablesize, ' Bytes');
  writeln('Sample Data: ', smpblocksize, ' Bytes');
  write('Sequencer Loop: ', zsmheader.sequencer_loopstart, ' - ', zsmheader.sequencer_loopend);

  textcolor(3);
  gotoxy(37, 22); write('(V)olume Attenuation: -6 dB');
  textcolor(7);
  gotoxy(68, 22); write('(S)cope Mode');
  textcolor(9);
  gotoxy(37, 23); write('0..F (un)mute Channel, Space: unmute all');
  textcolor(2);
  gotoxy(37, 24); write('+ - to increase/decrease Sequencer Position');
  textcolor(8);
  gotoxy(37, 25); write('Esc to exit        P toggle Pattern Display');

end;



procedure display_patt;
  var
    x, t: byte;
begin

  for x := 0 to 23 do
    for t := 0 to maxtracks do
    begin

      gotoxy(77-x, 16-t);
      if pattdisp[x, t] > 0 then
      begin
        if track_select[t] then textcolor(pattcol[pattdisp[x, t]mod 8])
        else textcolor(8);
        if pattdisp[x,t] > 7 then write(chr(219)) else write(chr(220));
      end
      else
        writeln(' ')

    end;
  textcolor(7);
  textbackground(0);

end;



begin
  lastpatpos := 65535;
  vumeter := 0;
  ln10 := ln(10);
  fillchar (pattdisp, 24*16, 0);
  fillchar (track_select, 16, $FF);
  scopemode := false;
  scopecol := 10;
  getmem(screenbuf, 256*128);


  marquee := '***dANCER*iN*A*bOX***';

  marquee := marquee + '   ...no drums detected yet...   ';

  dancer_on := true;
  dancer_dir := 0;
  dancer_x := 3;
  dancer_jump := 0;
  dancer_pose := 1;

  drums_detected := false;

  do_pdisplay := true;


  if paramstr(1) = '' then
  begin
    write('ZSM-Datei (ohne Erw.): ');
    readln(fname);
  end
  else
    fname := paramstr(1);
  fname := fname + '.zsm';


  if load_zsm(fname) <> 0 then
  begin
    writeln('Error opening ', fname);
    halt(1);
  end;


  calc_pattern_sizes;


  for i := 0 to 19 do
    titel[i+1] := zsmheader.titel[i];
  i := 20;
  while (i > 0) and (titel[i] = chr(0)) do dec(i);
  titel[0] := chr(i);

  for i := 0 to 19 do
    composer[i+1] := zsmheader.composer[i];
  i := 20;
  while (i > 0) and (composer[i] = chr(0)) do dec(i);
  composer[0] := chr(i);


  clrscr;

  display_static;

  goto_sequ(1);


  init_zsm_soundbuffer(bsize);

  if init_sound(bsize) > 0 then
  begin
    writeln('Error initializing Soundblaster');
    halt(1);
  end;


  asm mov ah, 01h; mov cx, 2607h; int 10h; end;

  bufstep := 0;
  repeat

  if not scopemode then
  begin
    inc(bufstep);

    if dancer_on then
    begin

      if bufstep mod 2 = 0 then
      begin
        if dancer_jump > 0 then inc(dancer_x, dancer_dir);
        if (dancer_x = 0) or (dancer_x = 6) then dancer_dir := 0;
{          if dancer_dir <> 0 then asm neg dancer_dir end;}
      end;

      textcolor(dancecol[(patternrow_act mod 8)div 2]);
      display_marquee;
      inc(marquee_pos);
      display_box;


      if drums_detected then
      begin

      if dancer_jump = 0 then
      begin
        {dancer_dir := 0;}
        if (patternrow_act mod 4 = 0) and (bufstep mod 4 = 0) then dancer_pose := random(6) + 1;
        if sync[$80] > 0 then dancer_pose := 11;
        if sync[$81] > 0 then dancer_jump := 3;
        if (sync[$82] > 0) and (bufstep mod 4 = 0) then dancer_pose := random(6)+1;
      end
      else
      begin
        if bufstep mod 4 = 0 then dec(dancer_jump);
        if (sync[$90] > 0) and (patternrow_act mod 8 = 0) then
        begin
         dancer_dir := random(2);
         if dancer_dir = 0 then dec(dancer_dir);
         if dancer_x = 0 then dancer_dir := 1;
         if dancer_x = 6 then dancer_dir := -1;
        end;
      end;
      end
      else
      begin

        dancer_pose := (patternrow_act div 2) mod 6 + 1;

        if (sync[$80] > 0) or (sync[$82] > 0) or (sync[$81] > 0)
          then drums_detected := true;
        if drums_detected then marquee := '***dANCER*iN*A*bOX***   .+*dRUMS+dEtECtEd*+.   ';

      end;
      display_dancer;
    end;

    if do_pdisplay then display_patt;

     for track := 1 to 10 do
     if chan_event[track-1] then
     begin
       if track_select[track-1] then textcolor(15) else textcolor(8);
       gotoxy(79, 17-track); write(chr(ord('0')+track-1));
     end
     else
     begin
       if track_select[track-1] then textcolor(9) else textcolor(8);
       gotoxy(79, 17-track); write(chr(ord('0')+track-1));
     end;

     for track := 11 to 16 do
     if chan_event[track-1] then
     begin
       if track_select[track-1] then textcolor(15) else textcolor(8);
       gotoxy(79, 17-track); write(chr(ord('A')+track-11));
     end
     else
     begin
       if track_select[track-1] then textcolor(9) else textcolor(8);
       gotoxy(79, 17-track); write(chr(ord('A')+track-11));
     end;
     textcolor(7);

    textcolor(2);
    gotoxy(35, 5); write(actual_sequ:4, ' /', zsmheader.sequencer_entries:4);
    gotoxy(35, 6); write(act_pattern_number:4, ' /', number_of_patterns:4);
    gotoxy(36, 7); write(patternrow_act:3, ' /', patternrowstotal:4);

    textcolor(3);
    gotoxy(35, 09); write(act_pattern_size:4);
    gotoxy(34, 10); write(pattheaderandtables:5);
    gotoxy(34, 11); write(patternpos:5);

    display_vu;

    if patternpos <> lastpatpos then
    begin
      textcolor(3);
      lastpatpos := patternpos;
      gotoxy(17, 12);
        write(round(patternpos*8 / (patternrow_act+1)):3);
      gotoxy(36, 12);
        write(patternpos / (patternrow_act+1) * 22050 / actual_spl_per_row:3:1, ' ');
      textcolor(2);
      gotoxy(34, 8); write(offset_in_patterndata:5);
    end;

    textcolor(8);
    gotoxy(34, 13); write(emptyflagbits div 8:5);
    textcolor(7);
    gotoxy(34, 14); write(purebits div 8:5);
    bitsum := purebits + emptyflagbits;
    if bitsum > 0 then begin
      {
      textcolor(8);
      gotoxy(36, 16); write(round(100 * emptyflagbits / bitsum):3);
      }
      gotoxy(1,15);
      textcolor(7);
      for i := 1 to round(40 * purebits / bitsum) do write('');
      textcolor(8);
      for i := round(40 * purebits / bitsum) + 1 to 40 do write('');
    end;

    fill_soundbuffer;
    sound_nextframe := false;



    repeat until sound_nextframe;

    asm
      mov ax, 0b00h;
      int 21h;
      mov key, al;
    end;
    if key then
    begin
      ch := readkey;

      i := 0;
      while (i < 16) and (upcase(ch) <> togglekey[i]) do inc(i);
      if i < 16 then
        track_select[i] := not track_select[i];

      if ord(ch) = 32 then for i := 0 to 15 do track_select[i] := true;

      if ch = '+' then begin inc_sequ; ch := chr(0); end;
      if ch = '-' then begin dec_sequ; ch := chr(0); end;

      if upcase(ch) = 'P' then
      begin
        do_pdisplay := not do_pdisplay;
        if not do_pdisplay then
          for i := 1 to 16 do begin
          gotoxy(54, i); write('                        '); end;
      end;

      if upcase(ch) = 'T' then
      begin
        if dancer_on then
        begin
          textcolor(1);
          display_box;
          gotoxy(42, 9); write('         ');
          gotoxy(42, 11); write('         ');
          gotoxy(42, 12); write('         ');
          gotoxy(42, 13);  write('  ..zZ   ');
          gotoxy(42, 14);  write('o_     ');
          gotoxy(41, 15); write('');
        end;
        dancer_on := not dancer_on;
      end;
      if upcase(ch) = 'V' then
      begin
        inc(mixvol);
        if mixvol > 2 then mixvol := 0;
        gotoxy(59, 22); textcolor(3);
        if mixvol > 0 then write('-',mixvol*6, ' dB ')
        else write ('0 dB  ');
      end;
      if upcase(ch) = 'S' then
      begin
        scopemode := true;
        asm
          mov ax, 13h; int 10h
          mov ax, 0a000h
          mov es, ax
          xor di, di
          db 66h; xor ax, ax
          db 66h; xor cx, cx
          mov cx, 16000
          db 66h; rep stosw

         {
          mov ah, 09h
          xor bh, bh
          mov bl, 15
          mov cx, 8
          mov al, 'H'
          int 10h
          }
        end;

        gotoxy(1,1);write('Hallo');

      end;
    end;



  end else
  begin

    if (patternrow_act mod 16 = 0) and scopecolchange then
    begin
      while scopecol = lastscopecol do scopecol := random(7)+9;
      lastscopecol := scopecol;
      scopecolchange := false;
    end;
    if patternrow_act mod 16 > 0 then scopecolchange := true;
    display_scope;

    fill_soundbuffer;
    sound_nextframe := false;



    repeat until sound_nextframe;

    asm
      mov ax, 0b00h;
      int 21h;
      mov key, al;
    end;
    if key then
    begin
      ch := readkey;

      i := 0;
      while (i < 16) and (upcase(ch) <> togglekey[i]) do inc(i);
      if i < 16 then
        track_select[i] := not track_select[i];

      if ord(ch) = 32 then for i := 0 to 15 do track_select[i] := true;

      if ch = '+' then begin inc_sequ; ch := chr(0); end;
      if ch = '-' then begin dec_sequ; ch := chr(0); end;
      if upcase(ch) = 'V' then
      begin
        inc(mixvol);
        if mixvol > 2 then mixvol := 0;
      end;
      if upcase(ch) = 'S' then
      begin
        scopemode := false;
        asm mov ax, 03h; int 10h end;
        asm mov ah, 01h; mov cx, 2607h; int 10h; end;
        display_static;
        gotoxy(59, 22); textcolor(3);
        if mixvol > 0 then write('-',mixvol*6, ' dB ')
        else write ('0 dB  ');
      end;
    end;

  end;

  until ch = chr(27);

  asm mov ax, 03h; int 10h end;
  asm mov ah, 01h; mov cx, 0607h; int 10h; end;
  textcolor(7);

  {writeln(key, '<<');}
  deinit_sound;

  clear_zsm;

  clrscr;
end.